#!/usr/bin/perl

$ENV{PERL_LWP_SSL_VERIFY_HOSTNAME}=0;
#----------------------------------------------------------------------------
# This script is to receive the cache information related to Twodegrees web 
# applications
# Functionalities:
#   1. Show all the cache object prod and pre-prod application servers
#   2. Show single cache object for prod and pre-prod application servers
#   3. Delete all the cache object for prod and pre-prod application servers
#   4. Delete single cache entry object for prod and pre-prod application servers 
#----------------------------------------------------------------------------
use warnings;
use strict;

use SOAP::Lite;
use iControlTypeCast;

my $sProfile;
my $environment;
my $hostname;

my $sHost = "";
my $sUID = "";
my $sPWD = "";
my $action = "";
my $url_name = "";
my @urls_all;
my $customer;
my $prod;
my $preprod;

my $num_args = $#ARGV + 1;
if ($num_args != 4) {
    &help();
}

#----------------------------------------------------------------------------
#Read the credentials and object information
#----------------------------------------------------------------------------
    $sHost = "api.auraredshield.com";
    $sUID = "api_svc_rw";
    $sPWD = $ARGV[0];
    $environment = $ARGV[1];
    $action = $ARGV[2];
    $url_name = $ARGV[3];

chomp ($sPWD);
chomp ($action);
chomp ($environment);
chomp ($url_name);

#Open the configuration file and read the content
open FILE, "Cache_Control.conf" or die $!;
my @lines;
while(<FILE>){
next if m/^#/m;
push (@lines, $_);
}
close(FILE);


my $single_line = $lines[0];
($customer, $prod, $preprod) = split(/:/, $single_line);
chomp ($customer);
chomp ($prod);
chomp ($preprod);

if ($customer ne "" && $prod ne "" && $preprod ne ""){
if ($environment eq "prod" || $environment eq "preprod"){
if ($environment eq "prod"){
    $sProfile = "/${customer}/${prod}_optimized_caching";
    $hostname = $prod;
} 

if ($environment eq "preprod"){
    $sProfile = "/${customer}/${preprod}_optimized_caching";
    $hostname = $preprod;
    }
} else {

    &help();

}
} else {
    
    &helpdoc();
}



#----------------------------------------------------------------------------
# The HTTP auth as part of SOAP.
#----------------------------------------------------------------------------
sub SOAP::Transport::HTTP::Client::get_basic_credentials {
        return "$sUID" => "$sPWD";
}


    
    my $aso_handle = SOAP::Lite
                            ->uri('urn:iControl:LocalLB/RAMCacheInformation')
                            -> proxy("https://$sHost/iControl/iControlPortal.cgi", ssl_opts => [ SSL_verify_mode => 0 ]);
    
if ($action eq "show" || $action eq "delete"){
if ($action eq "show"){
    &getRAMCacheInformation();
}

if ($action eq "delete"){
    &deleteRamCacheInformation($url_name);
}
} else {
    &help();

  }

#----------------------------------------------------------------------------
# Retrieve the RAM cache information related to the specific environment
#----------------------------------------------------------------------------
sub getRAMCacheInformation()
{
   
my $keys;
my  $soapResponse;

#print "The cache object to retrieve is $url_name ........\n";

  if ($url_name eq "all"){
        $keys = 
  {
    profile_name => $sProfile,
    host_name => $hostname,
    uri => "",
    maximum_responses => 100
    };
    
     $soapResponse = $aso_handle->get_ramcache_entry
  (
    SOAP::Data->name(keys => [$keys])
  );

    } else {
    if ($url_name ne ""){
        $keys = 
    {
        profile_name => $sProfile,
        host_name => $hostname,
        uri => $url_name,
        maximum_responses => 100
    };
         $soapResponse = $aso_handle->get_ramcache_entry_exact_match
  (
    SOAP::Data->name(keys => [$keys])
  );
    }
    
    }
    
  &checkResponse($soapResponse);
  my @RAMCacheEntryAofA = @{$soapResponse->result};
  
  for my $i (0 .. $#RAMCacheEntryAofA)
  {
    my $key_no = $i+1;
    print "List of cache information:\n";
    
    
    my @RAMCacheEntryList = @{$RAMCacheEntryAofA[$i]};
    
    if (scalar(@RAMCacheEntryList) == 0){
        print "None\n";
     }

    for my $j (0 .. $#RAMCacheEntryList)
    {
      my $RAMCacheEntry = $RAMCacheEntryList[$j];
      
      my $profile_name = "";
      my $host_name = "";
      my $uri = "";
      my $vary_type = "";
      my $vary_count = "";
      my $hits = "";
      my $received = "";
      my $last_sent = "";
      my $expiration = "";
      my $size = "";

      $profile_name = $RAMCacheEntry->{"profile_name"};
      $host_name = $RAMCacheEntry->{"host_name"};
      $uri = $RAMCacheEntry->{"uri"};
      push (@urls_all, $uri);
      if ( defined $RAMCacheEntry->{"vary_type"}){
            $vary_type = $RAMCacheEntry->{"vary_type"};
        }
      if ( defined $RAMCacheEntry->{"vary_count"}){
            $vary_count = $RAMCacheEntry->{"vary_count"};
        }
      
      $hits = $RAMCacheEntry->{"hits"};
      $received = $RAMCacheEntry->{"received"};
      $last_sent = $RAMCacheEntry->{"last_sent"};
      $expiration = $RAMCacheEntry->{"expiration"};
      $size = $RAMCacheEntry->{"size"};
      
      print "  [$j]\n";
      if($host_name ne ""){
        print "    Host Name   : $host_name\n";
       }
      
      if($uri ne ""){
        print "    URL         : $uri\n";
      }
      
      if($vary_type ne ""){
         print "    Vary Type   : $vary_type\n";
        }

        if($vary_count ne ""){
            print "    Vary Count  : $vary_count\n";
        }
      
      if($hits ne ""){
        print "    Hits        : $hits\n";
      }
     
      if($received ne ""){
        print "    Received    : ".scalar(gmtime($received))."\n";
       }
     
       if($last_sent ne ""){
        print "    Last Sent   : ".scalar(gmtime($last_sent))."\n";
        }
        
      if($expiration ne ""){
        print "    Expiration  : ".scalar(gmtime($expiration))."\n";
        }

      if($size ne ""){
        print "    Size        : $size\n";
        }
    }
    
  }
}

#----------------------------------------------------------------------------
# Delete the RAM cache information related to the specific environment
#----------------------------------------------------------------------------
sub deleteRamCacheInformation()
{

        if ($url_name eq "all"){

       if ($hostname ne ""){
            my $command = "";
            if ($environment eq "preprod"){
              $command = "curl -k -X POST 'https://$hostname/cache/delete?token=tfOwQlwlDNtTuJzgK0sJYujqGji02SynsV1jcFYvrBZdfAcT8CEZSq7nj7jne1020eZWfNjmd5HDzOthqVLBCHEnuJxB2Jp2jZWSTIaRYo6rQXxsWubpdsemrBhK0luj&name=/${customer}/${hostname}_optimized_caching'";
            }
            
        if ($environment eq "prod"){
              $command = "curl -k -X POST 'https://$hostname/cache/delete?token=T9d1ODeJ0qVa65czD77zjflLaGE1M2h0qWxUZq9WX5h5K72H6YdsvFwPeJ4nkYn9EnkEVV7Rrc3IpXYc2jbwiOGcmjJm95lGvZl3sYSCTN1TxkcnScuu2z4HJG2BUoRWHcD9WeSK7pOTvmRdAYxYnznKloCSkXa4bZgycFglD5QeOEZ3zVqpgqesOVN3aP2liUgpDWP1lG91C6a3KsjQb8D5hGoq73KDDG9f50JRGzrQXRTQRVxVX9B5SrLxMc2HXHtk4Who3YEU8bSanaTXqcCYzNaB7xH1wFsewNP5ytjZ&name=/${customer}/${hostname}_optimized_caching'";
            }
            #print "Command is $command\n";
            system($command) == 0
                    or die "Failed to delete the cache objects";
        }
        
        } else {
            
        if ($url_name ne ""){
                     my $key_to_delete =
                {
                        profile_name => $sProfile,
                        host_name => $hostname,
                        uri => $url_name,
                        maximum_responses => 100
                };

                my $soapResponse = $aso_handle->evict_ramcache_entry_v2
                (
                        SOAP::Data->name(keys => [$key_to_delete]),
                        SOAP::Data->name(exact_match => 0)
                );
                &checkResponse($soapResponse);

                my $response = $soapResponse->result;
                print "The object of $url_name has been deleted from cache\n";
            
            } else {
                &help();
            }
        

         }

}

#----------------------------------------------------------------------------
# Check the Response
#----------------------------------------------------------------------------
sub checkResponse()
{
  my ($soapResponse) = (@_);
  if ( $soapResponse->fault )
  {
    print $soapResponse->faultcode, " ", $soapResponse->faultstring, "\n";
    exit();
  }
}

sub help(){
    print "\nUsage: \n<Password> <Environment> <Action> <Show_Delete_All or Name of single object/URI>\n";
    print "\nExample1: pass123456 preprod show all\n";
    print "Example2: pass123456 prod show /assets/tiles/v18/L18/12/4037/2498.png\n";
    print "Example3: pass123456 prod delete all\n";
    print "Example4: pass123456 preprod delete /assets/tiles/v18/L18/12/4037/2498.png\n";
    exit;
}

sub helpdoc(){
    print "Please ensure that the configuration file of Cache_Control.conf is in the same directory on this executable and values are not corrupted.\n";
    exit;
}